<?php
// Include your database connection
include("db.php");

// Start the session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Enable error reporting for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);


// Base query
$sql = "SELECT Product_id, Product_name, SKU, Selling_price, MRP, qty, Product_image 
        FROM product 
        WHERE Delete_status = 0 AND parantid = 1  AND Product_name != ''";


// Execute the query
$result = $conn->query($sql);

// Prepare the response
if ($result && $result->num_rows > 0) {
    $products = [];
    while ($row = $result->fetch_assoc()) {
        $products[] = [
            'id' => $row['Product_id'],
            'productname' => $row['Product_name'],
            'sku' => $row['SKU'],
            'saleprice' => $row['Selling_price'],
            'mrp' => $row['MRP'],
            'qty' => $row['qty'] ?: '0', // Default to 0 if qty is empty
            'productimg' => $row['Product_image']
        ];
    }
    echo json_encode(['status' => 'success', 'data' => $products]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No products found']);
}
?>
